///////////////////////////////////////////////////////////////////////////////////////////////
//Item building code.
//Created: 12/16/04
//Last Update: 12/17/04
///////////////////////////////////////////////////////////////////////////////////////////////

var gItemBuild

///////////////////////////////////////////////////////////////////////////////////////////////

function StartItemBuild(mush, bg, bg2)
{
	if (gFlags[9] == false)
		{
			txt_BuildTut()
			
			gFlags[9] = true
		}
		
	gSuspendMovement = true;	

	//PlaySound("t-zombiez.it")

	///////////////////////////////////////////////////////////////////////////////////////////////

	var obs = ItemBuild_ConvertImageToObstacle(bg)
	var xy = ItemBuild_GetStartingXYImg(bg)
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	var n = ItemBuild_GetNeededMushrooms(obs)
	//var mush = new Array()
	
	//Abort(mush)
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	/*for (var i = 0; i < n; i++)
		{
			mush.push(Random(0,2))
		}*/
		
	///////////////////////////////////////////////////////////////////////////////////////////////

	gItemBuild = new ItemBuild(
	/*START X:*/						xy[0],
	/*START Y:*/						xy[1],
	/*MUSHROOM TYPES:*/			mush,
	/*OBSTRUCTION LIST:*/		obs,
	/*BACKGROUND*/					bg2,
	/*OBSTACLE IMG*/        "obs.png",
	/*FALL SPEED*/					12)
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	gItemBuild.Player.GetNewBlocks();
	
	RProcList.push(ItemBuild_Render)
	
	UProcList.push(ItemBuild_Update)
	
	///////////////////////////////////////////////////////////////////////////////////////////////
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_GetNeededMushrooms(obs)
{
	///////////////////////////////////////////////////////////////////////////////////////////////

	var Obs_Field = TwoDimensionalArray(320/16, 240/16, -1)
	var count = 0
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	for (var i = 0; i < obs.length; i++)
		{
			Obs_Field[obs[i].x][obs[i].y] = true;
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////
		
	for (var y = 0; y < 240/16; y++)
		for (var x = 0; x < (320/16); x++)
			{
				if (Obs_Field[x][y] != true) count++;
			}
			
	///////////////////////////////////////////////////////////////////////////////////////////////
			
	return count	
	
	///////////////////////////////////////////////////////////////////////////////////////////////
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_GetStartingXY(obs)
{
	var Obs_Field = TwoDimensionalArray(320/16, 240/16, -1)
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	for (var i = 0; i < obs.length; i++)
		{
			Obs_Field[obs[i].x][obs[i].y] = true;
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////
		
	for (var y = 0; y < 240/16; y++)
		for (var x = 0; x < (320/16)-1; x++)
			{
				if (Obs_Field[x][y] != true && Obs_Field[x+1][y] != true) return [x,y]
			}
			
	///////////////////////////////////////////////////////////////////////////////////////////////
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_GetStartingXYImg(img)
{
	var image = LoadSurface(img)
	
	var white = CreateColor(255,255,255)
	
	///////////////////////////////////////////////////////////////////////////////////////////////

	for (var x = 0; x < image.width; x+=16)
		for (var y = 0; y < image.height; y+=16)
			{
				if (image.getPixel(x,y).green == white.green)
					{
						return [x/16,y/16]
					}
			}
			
	///////////////////////////////////////////////////////////////////////////////////////////////
	
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_ConvertImageToObstacle(img)
{
	var image = LoadSurface(img)
	var obs_list = new Array()
	
	var white = CreateColor(255,255,255)
	var black = CreateColor(0,0,0)
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	for (var x = 0; x < image.width; x+=16)
		for (var y = 0; y < image.height; y+=16)
			{
				if (image.getPixel(x,y).red == 0 &&
						image.getPixel(x,y).blue == 0 &&
						image.getPixel(x,y).green == 0 ||
						image.getPixel(x,y).blue == 255)
					{
						obs_list.push(new ItemBuild_oBlocked(x/16,y/16))
					}
			}
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	return obs_list
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_Render()
{
	gItemBuild.Render()
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_Update()
{
	gItemBuild.Update()
	gItemBuild.UpdateInput()
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild(startx, starty, block_list, obs_list, bg, obs_img, spd)
{
	///////////////////////////////////////////////////////////////////////////////////////////////	
		
	this.me = this	
		
	this.PlacedBlocks = new Array() //Container for placed blocks
	
	this.Player = new ItemBuild_oPlayer(startx,starty,block_list)
	
	this.Container = new ItemBuild_oContainer(obs_list, obs_img) // The container type for the play field.

	this.Background = bg;
	
	this.FallTime = 0;
	
	this.Speed = spd;
	
	//Abort(this.Background)

	///////////////////////////////////////////////////////////////////////////////////////////////

	this.Render = function Render()
		{
		
			//Draw background
			
			GetImage( this.Background ).blit (0,0)
			
			//Draw line-limits
			
			this.Container.drawSelf();
		
			//Draw to-be-placed blocks		
			
			this.Player.CurrentBlocks.drawSelf();
			
			//Draw placed blocks		
			
			for (var i = 0; i < this.PlacedBlocks.length; i++) 
				{
					if (this.PlacedBlocks[i].linked == false)
						Picture = GetImage(GetMushroomTypePicture(this.PlacedBlocks[i].type))
					else
						{ Picture = GetImage(GetMushroomTypeLinkedPicture(this.PlacedBlocks[i].type)) } 
						
					Picture.blit(
						this.PlacedBlocks[i].x * Picture.width,
						this.PlacedBlocks[i].y * Picture.height)

				}	
						
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////	
		
	this.Update = function Update()
		{
			this.FallTime++;
			
			///////////////////////////////////////////////////////////////////////////////////////////////
			
			//Check block obstructions as to whether to place blocks or not.
			
			if (this.FallTime > this.Speed*4)
				{
					if (! this.IsObstructed( this.Player.CurrentBlocks.x, this.Player.CurrentBlocks.y +1 ) &&
							! this.IsObstructed( this.Player.CurrentBlocks.x2(), this.Player.CurrentBlocks.y2() +1) 
						 )			
						this.Player.CurrentBlocks.y++							
					else
						{
							this.PlaceBlocks();
						}				
					this.FallTime = 0
					this.CheckLinks() //Check placed-block order for links and update the information about them.	
				}
				
			///////////////////////////////////////////////////////////////////////////////////////////////
			
			if ( this.IsObstructed(this.Player.startx,this.Player.starty) || 
					 this.IsObstructed(this.Player.startx+1,this.Player.starty) )
					this.EndBuild();
		
			
			
				
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////		
	
	this.EndBuild = function EndBuild()
		{
			RemItem(RProcList, ItemBuild_Render)
			RemItem(UProcList, ItemBuild_Update)
			
			this.CheckLinks()
			
			//Execute after-build code here.
			
			for (var i = 0; i < this.PlacedBlocks.length; i++)
				{
					this.PlacedBlocks[i].hp = GetMushroomStats(this.PlacedBlocks[i]).hp
				}
			
			if (gDone) FinishShipBuild(this.PlacedBlocks)
			
			//TestShip(this.PlacedBlocks)
		}
		
	this.UpdateInput = function UpdateInput()
		{
		
			while ( AreKeysLeft() )
				{
					switch (GetKey())
						{		
							case k_up:								
								this.Player.CurrentBlocks.rotation++;
								if (this.Player.CurrentBlocks.rotation > 3) this.Player.CurrentBlocks.rotation = 0;
								while (this.IsObstructed( this.Player.CurrentBlocks.x2(), this.Player.CurrentBlocks.y2()) )
									{
										if (this.Player.CurrentBlocks.rotation > 0) 
											this.Player.CurrentBlocks.rotation--;
										else { this.Player.CurrentBlocks.rotation = 3 }
									}
									
							///////////////////////////////////////////////////////////////////////////////////////////////		
								
							break; case k_down:
								if (! this.IsObstructed( this.Player.CurrentBlocks.x, this.Player.CurrentBlocks.y +1 ) &&
										! this.IsObstructed( this.Player.CurrentBlocks.x2(), this.Player.CurrentBlocks.y2() +1) 
									 )			
									this.Player.CurrentBlocks.y++
								else
									{
										this.PlaceBlocks();
									}
									
							///////////////////////////////////////////////////////////////////////////////////////////////	
									
							break; case k_right:
								if (! this.IsObstructed( this.Player.CurrentBlocks.x + 1, this.Player.CurrentBlocks.y ) &&
										! this.IsObstructed( this.Player.CurrentBlocks.x2() + 1, this.Player.CurrentBlocks.y2()) 
									 )			
									this.Player.CurrentBlocks.x++		
									
							///////////////////////////////////////////////////////////////////////////////////////////////				
												
							break; case k_left:
								if (! this.IsObstructed( this.Player.CurrentBlocks.x - 1, this.Player.CurrentBlocks.y ) &&
										! this.IsObstructed( this.Player.CurrentBlocks.x2() - 1, this.Player.CurrentBlocks.y2()) 
									 )			
									this.Player.CurrentBlocks.x--									
							break;
						}
				}
									
		}				
		
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	this.CheckLinks = function CheckLinks()
		{
			var FieldType = TwoDimensionalArray(320/16, 240/16, -1)
			var FieldID = TwoDimensionalArray(320/16, 240/16, -1)
			
			///////////////////////////////////////////////////////////////////////////////////////////////
			
			for (var i = 0; i < this.PlacedBlocks.length; i++)
				{
					FieldType[this.PlacedBlocks[i].x][this.PlacedBlocks[i].y] = this.PlacedBlocks[i].type
					FieldID[this.PlacedBlocks[i].x][this.PlacedBlocks[i].y] = i
					this.PlacedBlocks.linked = false
				}
				
			///////////////////////////////////////////////////////////////////////////////////////////////
				
			for (var x = 0; x < FieldType.length; x++)
				for (var y = 0; y < FieldType.length; y++)
					{
						if (FieldType[x][y] != -1 && FieldType[x][y] != undefined)
							{
								
								CheckClimb(x,y,1,0,FieldType,FieldID, this)
								CheckClimb(x,y,-1,0,FieldType,FieldID, this)
								CheckClimb(x,y,0,1,FieldType,FieldID, this)
								CheckClimb(x,y,0,-1,FieldType,FieldID, this)
								
								CheckClimb(x,y,1,-1,FieldType,FieldID, this)
								CheckClimb(x,y,-1,1,FieldType,FieldID, this)
								CheckClimb(x,y,1,1,FieldType,FieldID, this)
								CheckClimb(x,y,-1,-1,FieldType,FieldID, this)								
									
							}																			
					}
					
			///////////////////////////////////////////////////////////////////////////////////////////////
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////	
		
	this.PlaceBlocks = function PlaceBlocks()
		{

			this.PlacedBlocks.push( new ItemBuild_oBlock(
															this.Player.CurrentBlocks.x, 
															this.Player.CurrentBlocks.y, 
															this.Player.CurrentBlocks.typeA) )
															
			this.PlacedBlocks.push( new ItemBuild_oBlock(
															this.Player.CurrentBlocks.x2(), 
															this.Player.CurrentBlocks.y2(), 
															this.Player.CurrentBlocks.typeB) )
																													
			this.Player.GetNewBlocks(this);												
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////	
		
	this.IsObstructed = function IsObstructed(x,y)
		{
			///////////////////////////////////////////////////////////////////////////////////////////////
		
			if (x > ( GetScreenWidth() / 16 ) - 1 ) return true
			if (x < 0) return true
			
			if (y > ( GetScreenHeight() /16 ) - 1) return true
			if (y < 0) return true			
			
			///////////////////////////////////////////////////////////////////////////////////////////////
		
			for (var i = 0; i < this.Container.ObstructionList.length; i++) 
				{ //Check default obstructions to see if the X Y would have a collision with them.
				
					if (this.Container.ObstructionList[i].x == x && 
							this.Container.ObstructionList[i].y == y)		
						return true		
				}
				
			///////////////////////////////////////////////////////////////////////////////////////////////
				
			for (var i = 0; i < this.PlacedBlocks.length; i++) 
				{ //Check Placed Blocks to see if the X Y would have a collision with any of them.
					if (this.PlacedBlocks[i].x == x &&
							this.PlacedBlocks[i].y == y)
						return true					
				}		
				
			///////////////////////////////////////////////////////////////////////////////////////////////
						
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////

}

function CheckClimb(x,y,xc,yc,FieldType,FieldID, that)
{
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	if (xc < 0 && x < 2) return
	if (xc > 0 && x > 17) return
	
	if (yc < 0 && y < 2) return
	if (yc > 0 && y > 17) return	
	
	///////////////////////////////////////////////////////////////////////////////////////////////

	if (FieldType[x+xc][y+yc] == FieldType[x][y] &&
		  FieldType[x+xc+xc][y+yc+yc] == FieldType[x][y])
	{
		that.PlacedBlocks[FieldID[x][y]].linked = true;
		that.PlacedBlocks[FieldID[x+xc][y+yc]].linked = true;
		that.PlacedBlocks[FieldID[x+xc+xc][y+yc+yc]].linked = true;
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_oContainer(obs_list, img)
{
	///////////////////////////////////////////////////////////////////////////////////////////////

	this.ObstructionList = obs_list
	this.img = img
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	this.drawSelf = function drawSelf()
		{
			for (var i = 0; i < this.ObstructionList.length; i++) 
				{ 
					
					var Picture = GetImage(this.img)
					Picture.blit( 
						this.ObstructionList[i].x * Picture.width, 
						this.ObstructionList[i].y * Picture.height)
				}		
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_oBlocked(x,y)
{
	this.x = x
	this.y = y
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_oBlock(x, y, type)
{

	this.x = x
	this.y = y
	
	this.type = type // type of block
	this.hp = 1
	this.linked = false  // whether the block has been linked or not
	
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_oCurrentBlocks(x,y,typeA,typeB)
{
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	this.x = x
	this.y = y
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	this.typeA = typeA
	this.typeB = typeB
	this.rotation = 0
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	this.RotationOffsetX = function RotationOffsetX()
		{
			switch (this.rotation)
				{
					case 0:
						return 1
					break; case 1:
						return 0
					break; case 2:
						return -1
					break; case 3:
						return 0
					break;
					
				}
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////
		
	this.RotationOffsetY = function RotationOffsetY()
		{
			switch (this.rotation)
				{
					case 0:
						return 0
					break; case 1:
						return -1
					break; case 2:
						return 0
					break; case 3:
						return 1
					break;
					
				}		
		}		
		
	///////////////////////////////////////////////////////////////////////////////////////////////
		
	this.drawSelf = function drawSelf()
		{
			var PictureA = GetImage(GetMushroomTypePicture(this.typeA))
			var PictureB = GetImage(GetMushroomTypePicture(this.typeB))	
			
			PictureA.blit(this.x * PictureA.width, this.y * PictureA.height)
			PictureB.blit(this.x2() * PictureB.width, this.y2() * PictureB.height)
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////
		
	this.x2 = function x2()
		{
			return this.x+this.RotationOffsetX()
		}
		
	///////////////////////////////////////////////////////////////////////////////////////////////
		
	this.y2 = function y2()
		{
			return this.y+this.RotationOffsetY()
		}				
		
	///////////////////////////////////////////////////////////////////////////////////////////////
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ItemBuild_oPlayer(x,y,list)
{

	///////////////////////////////////////////////////////////////////////////////////////////////

	this.startx = x
	this.starty = y 

	this.BlockList = list
		
	///////////////////////////////////////////////////////////////////////////////////////////////	
		
	this.CurrentBlocks = new ItemBuild_oCurrentBlocks(-1,-1,-1,-1)
	
	///////////////////////////////////////////////////////////////////////////////////////////////	
	
	this.GetNewBlocks = function GetNewBlocks(parent)
		{
			if (this.BlockList.length > 1)
				{
		
					var BlockA = Random(0,this.BlockList.length-1)
					var BlockB = Random(0,this.BlockList.length-1)
					
					while (BlockB == BlockA) BlockB = Random(0,this.BlockList.length-1)
					
					///////////////////////////////////////////////////////////////////////////////////////////////
		
					this.CurrentBlocks = new ItemBuild_oCurrentBlocks
						( this.startx, this.starty, this.BlockList[BlockA], this.BlockList[BlockB] )
						
					if (this.BlockList[BlockA] == undefined || this.BlockList[BlockB]	== undefined) Abort("Bad block inventory pick.")
					
					///////////////////////////////////////////////////////////////////////////////////////////////
						
					this.BlockList.splice(BlockA,1)
					if (BlockA > BlockB) this.BlockList.splice(BlockB,1)
					else { this.BlockList.splice(BlockB-1,1) } 
					
					///////////////////////////////////////////////////////////////////////////////////////////////
						
				}
			else { parent.EndBuild(); } 
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

/*

	Block rotations

0
 AB
1 
 B
 A 
2 
 BA 
3 
 A
 B
 
*/	
